function Matches = loadCorrespondences(Files)

Matches = [];

if strfind(Files{1}{1}, 'webcam')
    source = 1; target = 2;
elseif strfind(Files{1}{1}, 'dslr')
    source = 2; target = 1;
else
    disp('only supports webcam and dslr domains');
    return;  
end

correspondence = load_same_object_and_viewpoint;

% Get matching pairs of images based on ground truth correspondences
curr = 1;
Corr = reshape([correspondence{:}], [2 length([correspondence{:}])/2]);
for k = 1:length(Files{1})
    % for each source (webcam) image
    [isMatch, whichOne] = ismember(Files{1}{k}, Corr(source,:));

    % check if this webcam image has a match in dslr
    if isMatch
       [isThere fileInd ] = ismember(Corr(target,whichOne), Files{2});
       if ~isThere
	  error('dslr image not found');
       end
       Matches(curr, :) = [k fileInd];
       curr = curr + 1;
    end
end


%
% List of images in 'webcam' and corresponding image in 'dslr' that has 
% the same object (same 'object_id') and similar viewpoint.
%

function correspondence = load_same_object_and_viewpoint()
correspondence = { ...
    {...
        'webcam/images/back_pack/frame_0001.jpg', 'dslr/images/back_pack/frame_0001.jpg', ...
        'webcam/images/back_pack/frame_0003.jpg', 'dslr/images/back_pack/frame_0002.jpg', ...
        'webcam/images/back_pack/frame_0010.jpg', 'dslr/images/back_pack/frame_0003.jpg', ...
        'webcam/images/back_pack/frame_0008.jpg', 'dslr/images/back_pack/frame_0004.jpg', ...
        'webcam/images/back_pack/frame_0016.jpg', 'dslr/images/back_pack/frame_0005.jpg', ...
        'webcam/images/back_pack/frame_0015.jpg', 'dslr/images/back_pack/frame_0006.jpg', ...
        'webcam/images/back_pack/frame_0019.jpg', 'dslr/images/back_pack/frame_0007.jpg', ...
        'webcam/images/back_pack/frame_0022.jpg', 'dslr/images/back_pack/frame_0008.jpg', ...
        'webcam/images/back_pack/frame_0026.jpg', 'dslr/images/back_pack/frame_0009.jpg', ...
        'webcam/images/back_pack/frame_0027.jpg', 'dslr/images/back_pack/frame_0010.jpg', ...
        'webcam/images/back_pack/frame_0028.jpg', 'dslr/images/back_pack/frame_0011.jpg', ...
        'webcam/images/back_pack/frame_0029.jpg', 'dslr/images/back_pack/frame_0012.jpg' ...
    },...
    {...
        'webcam/images/bike/frame_0001.jpg', 'dslr/images/bike/frame_0002.jpg', ...
        'webcam/images/bike/frame_0002.jpg', 'dslr/images/bike/frame_0003.jpg', ...
        'webcam/images/bike/frame_0003.jpg', 'dslr/images/bike/frame_0004.jpg', ...
        'webcam/images/bike/frame_0006.jpg', 'dslr/images/bike/frame_0006.jpg', ...
        'webcam/images/bike/frame_0005.jpg', 'dslr/images/bike/frame_0007.jpg', ...
        'webcam/images/bike/frame_0004.jpg', 'dslr/images/bike/frame_0008.jpg', ...
        'webcam/images/bike/frame_0010.jpg', 'dslr/images/bike/frame_0009.jpg', ...
        'webcam/images/bike/frame_0009.jpg', 'dslr/images/bike/frame_0010.jpg', ...
        'webcam/images/bike/frame_0008.jpg', 'dslr/images/bike/frame_0011.jpg', ...
        'webcam/images/bike/frame_0015.jpg', 'dslr/images/bike/frame_0012.jpg', ...
        'webcam/images/bike/frame_0013.jpg', 'dslr/images/bike/frame_0013.jpg', ...
        'webcam/images/bike/frame_0012.jpg', 'dslr/images/bike/frame_0014.jpg', ...
        'webcam/images/bike/frame_0011.jpg', 'dslr/images/bike/frame_0015.jpg', ...
        'webcam/images/bike/frame_0016.jpg', 'dslr/images/bike/frame_0016.jpg', ...
        'webcam/images/bike/frame_0017.jpg', 'dslr/images/bike/frame_0017.jpg', ...
        'webcam/images/bike/frame_0018.jpg', 'dslr/images/bike/frame_0018.jpg', ...
        'webcam/images/bike/frame_0019.jpg', 'dslr/images/bike/frame_0019.jpg', ...
        'webcam/images/bike/frame_0020.jpg', 'dslr/images/bike/frame_0020.jpg', ...
        'webcam/images/bike/frame_0021.jpg', 'dslr/images/bike/frame_0021.jpg' ...
    },...
    {...
        'webcam/images/bike_helmet/frame_0002.jpg', 'dslr/images/bike_helmet/frame_0001.jpg', ...
        'webcam/images/bike_helmet/frame_0006.jpg', 'dslr/images/bike_helmet/frame_0002.jpg', ...
        'webcam/images/bike_helmet/frame_0012.jpg', 'dslr/images/bike_helmet/frame_0003.jpg', ...
        'webcam/images/bike_helmet/frame_0013.jpg', 'dslr/images/bike_helmet/frame_0004.jpg', ...
        'webcam/images/bike_helmet/frame_0011.jpg', 'dslr/images/bike_helmet/frame_0005.jpg', ...
        'webcam/images/bike_helmet/frame_0010.jpg', 'dslr/images/bike_helmet/frame_0006.jpg', ...
        'webcam/images/bike_helmet/frame_0014.jpg', 'dslr/images/bike_helmet/frame_0007.jpg', ...
        'webcam/images/bike_helmet/frame_0017.jpg', 'dslr/images/bike_helmet/frame_0008.jpg', ...
        'webcam/images/bike_helmet/frame_0018.jpg', 'dslr/images/bike_helmet/frame_0009.jpg', ...
        'webcam/images/bike_helmet/frame_0019.jpg', 'dslr/images/bike_helmet/frame_0010.jpg', ...
        'webcam/images/bike_helmet/frame_0016.jpg', 'dslr/images/bike_helmet/frame_0011.jpg', ...
        'webcam/images/bike_helmet/frame_0015.jpg', 'dslr/images/bike_helmet/frame_0012.jpg', ...
        'webcam/images/bike_helmet/frame_0022.jpg', 'dslr/images/bike_helmet/frame_0014.jpg', ...
        'webcam/images/bike_helmet/frame_0023.jpg', 'dslr/images/bike_helmet/frame_0015.jpg', ...
        'webcam/images/bike_helmet/frame_0021.jpg', 'dslr/images/bike_helmet/frame_0017.jpg', ...
        'webcam/images/bike_helmet/frame_0024.jpg', 'dslr/images/bike_helmet/frame_0019.jpg', ...
        'webcam/images/bike_helmet/frame_0028.jpg', 'dslr/images/bike_helmet/frame_0021.jpg', ...
        'webcam/images/bike_helmet/frame_0025.jpg', 'dslr/images/bike_helmet/frame_0022.jpg', ...
        'webcam/images/bike_helmet/frame_0027.jpg', 'dslr/images/bike_helmet/frame_0023.jpg', ...
        'webcam/images/bike_helmet/frame_0026.jpg', 'dslr/images/bike_helmet/frame_0024.jpg' ...
    },...
    {...
        'webcam/images/bookcase/frame_0002.jpg', 'dslr/images/bookcase/frame_0001.jpg', ...
        'webcam/images/bookcase/frame_0001.jpg', 'dslr/images/bookcase/frame_0002.jpg', ...
        'webcam/images/bookcase/frame_0003.jpg', 'dslr/images/bookcase/frame_0003.jpg', ...
        'webcam/images/bookcase/frame_0004.jpg', 'dslr/images/bookcase/frame_0004.jpg', ...
        'webcam/images/bookcase/frame_0005.jpg', 'dslr/images/bookcase/frame_0005.jpg', ...
        'webcam/images/bookcase/frame_0008.jpg', 'dslr/images/bookcase/frame_0006.jpg', ...
        'webcam/images/bookcase/frame_0007.jpg', 'dslr/images/bookcase/frame_0007.jpg', ...
        'webcam/images/bookcase/frame_0006.jpg', 'dslr/images/bookcase/frame_0008.jpg', ...
        'webcam/images/bookcase/frame_0009.jpg', 'dslr/images/bookcase/frame_0009.jpg', ...
        'webcam/images/bookcase/frame_0010.jpg', 'dslr/images/bookcase/frame_0010.jpg', ...
        'webcam/images/bookcase/frame_0012.jpg', 'dslr/images/bookcase/frame_0011.jpg', ...
        'webcam/images/bookcase/frame_0011.jpg', 'dslr/images/bookcase/frame_0012.jpg' ...
    },...
    {...
        'webcam/images/bottle/frame_0001.jpg', 'dslr/images/bottle/frame_0001.jpg', ...
        'webcam/images/bottle/frame_0002.jpg', 'dslr/images/bottle/frame_0003.jpg', ...
        'webcam/images/bottle/frame_0003.jpg', 'dslr/images/bottle/frame_0004.jpg', ...
        'webcam/images/bottle/frame_0005.jpg', 'dslr/images/bottle/frame_0006.jpg', ...
        'webcam/images/bottle/frame_0006.jpg', 'dslr/images/bottle/frame_0007.jpg', ...
        'webcam/images/bottle/frame_0007.jpg', 'dslr/images/bottle/frame_0009.jpg', ...
        'webcam/images/bottle/frame_0008.jpg', 'dslr/images/bottle/frame_0010.jpg', ...
        'webcam/images/bottle/frame_0010.jpg', 'dslr/images/bottle/frame_0012.jpg', ...
        'webcam/images/bottle/frame_0011.jpg', 'dslr/images/bottle/frame_0013.jpg', ...
        'webcam/images/bottle/frame_0016.jpg', 'dslr/images/bottle/frame_0014.jpg', ...
        'webcam/images/bottle/frame_0015.jpg', 'dslr/images/bottle/frame_0016.jpg' ...
    },...
    {...
        'webcam/images/calculator/frame_0011.jpg', 'dslr/images/calculator/frame_0001.jpg', ...
        'webcam/images/calculator/frame_0008.jpg', 'dslr/images/calculator/frame_0002.jpg', ...
        'webcam/images/calculator/frame_0009.jpg', 'dslr/images/calculator/frame_0003.jpg', ...
        'webcam/images/calculator/frame_0007.jpg', 'dslr/images/calculator/frame_0004.jpg', ...
        'webcam/images/calculator/frame_0012.jpg', 'dslr/images/calculator/frame_0005.jpg', ...
        'webcam/images/calculator/frame_0016.jpg', 'dslr/images/calculator/frame_0006.jpg', ...
        'webcam/images/calculator/frame_0017.jpg', 'dslr/images/calculator/frame_0007.jpg', ...
        'webcam/images/calculator/frame_0018.jpg', 'dslr/images/calculator/frame_0008.jpg', ...
        'webcam/images/calculator/frame_0023.jpg', 'dslr/images/calculator/frame_0010.jpg', ...
        'webcam/images/calculator/frame_0031.jpg', 'dslr/images/calculator/frame_0011.jpg', ...
        'webcam/images/calculator/frame_0025.jpg', 'dslr/images/calculator/frame_0012.jpg' ...
    },...
    {...
        'webcam/images/desk_chair/frame_0007.jpg', 'dslr/images/desk_chair/frame_0001.jpg', ...
        'webcam/images/desk_chair/frame_0005.jpg', 'dslr/images/desk_chair/frame_0002.jpg', ...
        'webcam/images/desk_chair/frame_0004.jpg', 'dslr/images/desk_chair/frame_0003.jpg', ...
        'webcam/images/desk_chair/frame_0010.jpg', 'dslr/images/desk_chair/frame_0004.jpg', ...
        'webcam/images/desk_chair/frame_0014.jpg', 'dslr/images/desk_chair/frame_0005.jpg', ...
        'webcam/images/desk_chair/frame_0013.jpg', 'dslr/images/desk_chair/frame_0006.jpg', ...
        'webcam/images/desk_chair/frame_0029.jpg', 'dslr/images/desk_chair/frame_0007.jpg', ...
        'webcam/images/desk_chair/frame_0030.jpg', 'dslr/images/desk_chair/frame_0008.jpg', ...
        'webcam/images/desk_chair/frame_0035.jpg', 'dslr/images/desk_chair/frame_0009.jpg', ...
        'webcam/images/desk_chair/frame_0040.jpg', 'dslr/images/desk_chair/frame_0010.jpg', ...
        'webcam/images/desk_chair/frame_0038.jpg', 'dslr/images/desk_chair/frame_0011.jpg', ...
        'webcam/images/desk_chair/frame_0039.jpg', 'dslr/images/desk_chair/frame_0012.jpg', ...
        'webcam/images/desk_chair/frame_0037.jpg', 'dslr/images/desk_chair/frame_0013.jpg' ...
    },...
    {...
        'webcam/images/desk_lamp/frame_0001.jpg', 'dslr/images/desk_lamp/frame_0001.jpg', ...
        'webcam/images/desk_lamp/frame_0002.jpg', 'dslr/images/desk_lamp/frame_0002.jpg', ...
        'webcam/images/desk_lamp/frame_0009.jpg', 'dslr/images/desk_lamp/frame_0003.jpg', ...
        'webcam/images/desk_lamp/frame_0008.jpg', 'dslr/images/desk_lamp/frame_0004.jpg', ...
        'webcam/images/desk_lamp/frame_0007.jpg', 'dslr/images/desk_lamp/frame_0005.jpg', ...
        'webcam/images/desk_lamp/frame_0006.jpg', 'dslr/images/desk_lamp/frame_0006.jpg', ...
        'webcam/images/desk_lamp/frame_0011.jpg', 'dslr/images/desk_lamp/frame_0007.jpg', ...
        'webcam/images/desk_lamp/frame_0012.jpg', 'dslr/images/desk_lamp/frame_0008.jpg', ...
        'webcam/images/desk_lamp/frame_0013.jpg', 'dslr/images/desk_lamp/frame_0009.jpg', ...
        'webcam/images/desk_lamp/frame_0014.jpg', 'dslr/images/desk_lamp/frame_0010.jpg', ...
        'webcam/images/desk_lamp/frame_0015.jpg', 'dslr/images/desk_lamp/frame_0011.jpg', ...
        'webcam/images/desk_lamp/frame_0016.jpg', 'dslr/images/desk_lamp/frame_0012.jpg', ...
        'webcam/images/desk_lamp/frame_0017.jpg', 'dslr/images/desk_lamp/frame_0013.jpg', ...
        'webcam/images/desk_lamp/frame_0018.jpg', 'dslr/images/desk_lamp/frame_0014.jpg' ...
    },...
    {...
        'webcam/images/desktop_computer/frame_0001.jpg', 'dslr/images/desktop_computer/frame_0001.jpg', ...
        'webcam/images/desktop_computer/frame_0002.jpg', 'dslr/images/desktop_computer/frame_0002.jpg', ...
        'webcam/images/desktop_computer/frame_0008.jpg', 'dslr/images/desktop_computer/frame_0003.jpg', ...
        'webcam/images/desktop_computer/frame_0009.jpg', 'dslr/images/desktop_computer/frame_0004.jpg', ...
        'webcam/images/desktop_computer/frame_0010.jpg', 'dslr/images/desktop_computer/frame_0005.jpg', ...
        'webcam/images/desktop_computer/frame_0013.jpg', 'dslr/images/desktop_computer/frame_0006.jpg', ...
        'webcam/images/desktop_computer/frame_0014.jpg', 'dslr/images/desktop_computer/frame_0009.jpg', ...
        'webcam/images/desktop_computer/frame_0016.jpg', 'dslr/images/desktop_computer/frame_0010.jpg', ...
        'webcam/images/desktop_computer/frame_0017.jpg', 'dslr/images/desktop_computer/frame_0011.jpg', ...
        'webcam/images/desktop_computer/frame_0018.jpg', 'dslr/images/desktop_computer/frame_0012.jpg', ...
        'webcam/images/desktop_computer/frame_0019.jpg', 'dslr/images/desktop_computer/frame_0013.jpg', ...
        'webcam/images/desktop_computer/frame_0020.jpg', 'dslr/images/desktop_computer/frame_0014.jpg', ...
        'webcam/images/desktop_computer/frame_0021.jpg', 'dslr/images/desktop_computer/frame_0015.jpg' ...
    },...
    {...
        'webcam/images/file_cabinet/frame_0008.jpg', 'dslr/images/file_cabinet/frame_0001.jpg', ...
        'webcam/images/file_cabinet/frame_0009.jpg', 'dslr/images/file_cabinet/frame_0002.jpg', ...
        'webcam/images/file_cabinet/frame_0004.jpg', 'dslr/images/file_cabinet/frame_0003.jpg', ...
        'webcam/images/file_cabinet/frame_0001.jpg', 'dslr/images/file_cabinet/frame_0004.jpg', ...
        'webcam/images/file_cabinet/frame_0010.jpg', 'dslr/images/file_cabinet/frame_0005.jpg', ...
        'webcam/images/file_cabinet/frame_0011.jpg', 'dslr/images/file_cabinet/frame_0006.jpg', ...
        'webcam/images/file_cabinet/frame_0012.jpg', 'dslr/images/file_cabinet/frame_0007.jpg', ...
        'webcam/images/file_cabinet/frame_0014.jpg', 'dslr/images/file_cabinet/frame_0008.jpg', ...
        'webcam/images/file_cabinet/frame_0013.jpg', 'dslr/images/file_cabinet/frame_0009.jpg', ...
        'webcam/images/file_cabinet/frame_0016.jpg', 'dslr/images/file_cabinet/frame_0010.jpg', ...
        'webcam/images/file_cabinet/frame_0015.jpg', 'dslr/images/file_cabinet/frame_0012.jpg', ...
        'webcam/images/file_cabinet/frame_0017.jpg', 'dslr/images/file_cabinet/frame_0013.jpg', ...
        'webcam/images/file_cabinet/frame_0018.jpg', 'dslr/images/file_cabinet/frame_0014.jpg', ...
        'webcam/images/file_cabinet/frame_0019.jpg', 'dslr/images/file_cabinet/frame_0015.jpg' ...
    },...
    {...
        'webcam/images/headphones/frame_0001.jpg', 'dslr/images/headphones/frame_0001.jpg', ...
        'webcam/images/headphones/frame_0008.jpg', 'dslr/images/headphones/frame_0003.jpg', ...
        'webcam/images/headphones/frame_0009.jpg', 'dslr/images/headphones/frame_0005.jpg', ...
        'webcam/images/headphones/frame_0016.jpg', 'dslr/images/headphones/frame_0006.jpg', ...
        'webcam/images/headphones/frame_0017.jpg', 'dslr/images/headphones/frame_0008.jpg', ...
        'webcam/images/headphones/frame_0018.jpg', 'dslr/images/headphones/frame_0009.jpg', ...
        'webcam/images/headphones/frame_0019.jpg', 'dslr/images/headphones/frame_0010.jpg', ...
        'webcam/images/headphones/frame_0023.jpg', 'dslr/images/headphones/frame_0012.jpg', ...
        'webcam/images/headphones/frame_0024.jpg', 'dslr/images/headphones/frame_0013.jpg' ...
    },...
    {...
        'webcam/images/keyboard/frame_0001.jpg', 'dslr/images/keyboard/frame_0001.jpg', ...
        'webcam/images/keyboard/frame_0002.jpg', 'dslr/images/keyboard/frame_0002.jpg', ...
        'webcam/images/keyboard/frame_0004.jpg', 'dslr/images/keyboard/frame_0004.jpg', ...
        'webcam/images/keyboard/frame_0010.jpg', 'dslr/images/keyboard/frame_0005.jpg', ...
        'webcam/images/keyboard/frame_0009.jpg', 'dslr/images/keyboard/frame_0006.jpg', ...
        'webcam/images/keyboard/frame_0018.jpg', 'dslr/images/keyboard/frame_0007.jpg', ...
        'webcam/images/keyboard/frame_0019.jpg', 'dslr/images/keyboard/frame_0008.jpg', ...
        'webcam/images/keyboard/frame_0027.jpg', 'dslr/images/keyboard/frame_0009.jpg', ...
        'webcam/images/keyboard/frame_0026.jpg', 'dslr/images/keyboard/frame_0010.jpg' ...
    },...
    {...
        'webcam/images/laptop_computer/frame_0006.jpg', 'dslr/images/laptop_computer/frame_0001.jpg', ...
        'webcam/images/laptop_computer/frame_0003.jpg', 'dslr/images/laptop_computer/frame_0002.jpg', ...
        'webcam/images/laptop_computer/frame_0001.jpg', 'dslr/images/laptop_computer/frame_0003.jpg', ...
        'webcam/images/laptop_computer/frame_0008.jpg', 'dslr/images/laptop_computer/frame_0004.jpg', ...
        'webcam/images/laptop_computer/frame_0009.jpg', 'dslr/images/laptop_computer/frame_0005.jpg', ...
        'webcam/images/laptop_computer/frame_0010.jpg', 'dslr/images/laptop_computer/frame_0006.jpg', ...
        'webcam/images/laptop_computer/frame_0011.jpg', 'dslr/images/laptop_computer/frame_0007.jpg', ...
        'webcam/images/laptop_computer/frame_0012.jpg', 'dslr/images/laptop_computer/frame_0009.jpg', ...
        'webcam/images/laptop_computer/frame_0015.jpg', 'dslr/images/laptop_computer/frame_0010.jpg', ...
        'webcam/images/laptop_computer/frame_0016.jpg', 'dslr/images/laptop_computer/frame_0011.jpg', ...
        'webcam/images/laptop_computer/frame_0017.jpg', 'dslr/images/laptop_computer/frame_0012.jpg', ...
        'webcam/images/laptop_computer/frame_0018.jpg', 'dslr/images/laptop_computer/frame_0013.jpg', ...
        'webcam/images/laptop_computer/frame_0019.jpg', 'dslr/images/laptop_computer/frame_0014.jpg', ...
        'webcam/images/laptop_computer/frame_0020.jpg', 'dslr/images/laptop_computer/frame_0015.jpg', ...
        'webcam/images/laptop_computer/frame_0021.jpg', 'dslr/images/laptop_computer/frame_0016.jpg', ...
        'webcam/images/laptop_computer/frame_0022.jpg', 'dslr/images/laptop_computer/frame_0017.jpg', ...
        'webcam/images/laptop_computer/frame_0023.jpg', 'dslr/images/laptop_computer/frame_0018.jpg', ...
        'webcam/images/laptop_computer/frame_0024.jpg', 'dslr/images/laptop_computer/frame_0019.jpg', ...
        'webcam/images/laptop_computer/frame_0025.jpg', 'dslr/images/laptop_computer/frame_0020.jpg', ...
        'webcam/images/laptop_computer/frame_0026.jpg', 'dslr/images/laptop_computer/frame_0022.jpg', ...
        'webcam/images/laptop_computer/frame_0028.jpg', 'dslr/images/laptop_computer/frame_0023.jpg', ...
        'webcam/images/laptop_computer/frame_0029.jpg', 'dslr/images/laptop_computer/frame_0024.jpg', ...
    },...
    {...
        'webcam/images/letter_tray/frame_0004.jpg', 'dslr/images/letter_tray/frame_0001.jpg', ...
        'webcam/images/letter_tray/frame_0001.jpg', 'dslr/images/letter_tray/frame_0002.jpg', ...
        'webcam/images/letter_tray/frame_0006.jpg', 'dslr/images/letter_tray/frame_0003.jpg', ...
        'webcam/images/letter_tray/frame_0007.jpg', 'dslr/images/letter_tray/frame_0004.jpg', ...
        'webcam/images/letter_tray/frame_0008.jpg', 'dslr/images/letter_tray/frame_0005.jpg', ...
        'webcam/images/letter_tray/frame_0013.jpg', 'dslr/images/letter_tray/frame_0006.jpg', ...
        'webcam/images/letter_tray/frame_0009.jpg', 'dslr/images/letter_tray/frame_0007.jpg', ...
        'webcam/images/letter_tray/frame_0010.jpg', 'dslr/images/letter_tray/frame_0008.jpg', ...
        'webcam/images/letter_tray/frame_0011.jpg', 'dslr/images/letter_tray/frame_0009.jpg', ...
        'webcam/images/letter_tray/frame_0012.jpg', 'dslr/images/letter_tray/frame_0010.jpg', ...
        'webcam/images/letter_tray/frame_0014.jpg', 'dslr/images/letter_tray/frame_0011.jpg', ...
        'webcam/images/letter_tray/frame_0015.jpg', 'dslr/images/letter_tray/frame_0012.jpg', ...
        'webcam/images/letter_tray/frame_0016.jpg', 'dslr/images/letter_tray/frame_0013.jpg', ...        
        'webcam/images/letter_tray/frame_0017.jpg', 'dslr/images/letter_tray/frame_0015.jpg', ...
        'webcam/images/letter_tray/frame_0018.jpg', 'dslr/images/letter_tray/frame_0015.jpg', ...
        'webcam/images/letter_tray/frame_0019.jpg', 'dslr/images/letter_tray/frame_0016.jpg' ...
    },...
    {...        
        'webcam/images/mobile_phone/frame_0005.jpg', 'dslr/images/mobile_phone/frame_0002.jpg', ...
        'webcam/images/mobile_phone/frame_0001.jpg', 'dslr/images/mobile_phone/frame_0003.jpg', ...
        'webcam/images/mobile_phone/frame_0003.jpg', 'dslr/images/mobile_phone/frame_0004.jpg', ...
        'webcam/images/mobile_phone/frame_0006.jpg', 'dslr/images/mobile_phone/frame_0005.jpg', ...
        'webcam/images/mobile_phone/frame_0007.jpg', 'dslr/images/mobile_phone/frame_0007.jpg', ...
        'webcam/images/mobile_phone/frame_0008.jpg', 'dslr/images/mobile_phone/frame_0008.jpg', ...
        'webcam/images/mobile_phone/frame_0009.jpg', 'dslr/images/mobile_phone/frame_0009.jpg', ...
        'webcam/images/mobile_phone/frame_0010.jpg', 'dslr/images/mobile_phone/frame_0010.jpg', ...
        'webcam/images/mobile_phone/frame_0011.jpg', 'dslr/images/mobile_phone/frame_0011.jpg', ...
        'webcam/images/mobile_phone/frame_0012.jpg', 'dslr/images/mobile_phone/frame_0012.jpg', ...
        'webcam/images/mobile_phone/frame_0013.jpg', 'dslr/images/mobile_phone/frame_0013.jpg', ...
        'webcam/images/mobile_phone/frame_0014.jpg', 'dslr/images/mobile_phone/frame_0014.jpg', ...
        'webcam/images/mobile_phone/frame_0015.jpg', 'dslr/images/mobile_phone/frame_0015.jpg', ...
        'webcam/images/mobile_phone/frame_0016.jpg', 'dslr/images/mobile_phone/frame_0016.jpg', ...
        'webcam/images/mobile_phone/frame_0017.jpg', 'dslr/images/mobile_phone/frame_0017.jpg', ...
        'webcam/images/mobile_phone/frame_0018.jpg', 'dslr/images/mobile_phone/frame_0018.jpg', ...
        'webcam/images/mobile_phone/frame_0019.jpg', 'dslr/images/mobile_phone/frame_0019.jpg', ...
        'webcam/images/mobile_phone/frame_0020.jpg', 'dslr/images/mobile_phone/frame_0020.jpg', ...
        'webcam/images/mobile_phone/frame_0021.jpg', 'dslr/images/mobile_phone/frame_0021.jpg', ...
        'webcam/images/mobile_phone/frame_0022.jpg', 'dslr/images/mobile_phone/frame_0022.jpg', ...
        'webcam/images/mobile_phone/frame_0023.jpg', 'dslr/images/mobile_phone/frame_0023.jpg', ...
        'webcam/images/mobile_phone/frame_0024.jpg', 'dslr/images/mobile_phone/frame_0024.jpg', ...
        'webcam/images/mobile_phone/frame_0026.jpg', 'dslr/images/mobile_phone/frame_0025.jpg', ...
        'webcam/images/mobile_phone/frame_0029.jpg', 'dslr/images/mobile_phone/frame_0026.jpg', ...
        'webcam/images/mobile_phone/frame_0028.jpg', 'dslr/images/mobile_phone/frame_0027.jpg', ...
        'webcam/images/mobile_phone/frame_0027.jpg', 'dslr/images/mobile_phone/frame_0028.jpg', ...
        'webcam/images/mobile_phone/frame_0030.jpg', 'dslr/images/mobile_phone/frame_0030.jpg'  ...
    },...
    {...
        'webcam/images/monitor/frame_0003.jpg', 'dslr/images/monitor/frame_0001.jpg', ...
        'webcam/images/monitor/frame_0004.jpg', 'dslr/images/monitor/frame_0002.jpg', ...
        'webcam/images/monitor/frame_0001.jpg', 'dslr/images/monitor/frame_0004.jpg', ...
        'webcam/images/monitor/frame_0013.jpg', 'dslr/images/monitor/frame_0005.jpg', ...
        'webcam/images/monitor/frame_0010.jpg', 'dslr/images/monitor/frame_0006.jpg', ...
        'webcam/images/monitor/frame_0008.jpg', 'dslr/images/monitor/frame_0007.jpg', ...
        'webcam/images/monitor/frame_0028.jpg', 'dslr/images/monitor/frame_0008.jpg', ...
        'webcam/images/monitor/frame_0022.jpg', 'dslr/images/monitor/frame_0009.jpg', ...
        'webcam/images/monitor/frame_0029.jpg', 'dslr/images/monitor/frame_0010.jpg', ...
        'webcam/images/monitor/frame_0031.jpg', 'dslr/images/monitor/frame_0011.jpg', ...
        'webcam/images/monitor/frame_0032.jpg', 'dslr/images/monitor/frame_0012.jpg', ...
        'webcam/images/monitor/frame_0033.jpg', 'dslr/images/monitor/frame_0013.jpg', ...
        'webcam/images/monitor/frame_0034.jpg', 'dslr/images/monitor/frame_0014.jpg', ...
        'webcam/images/monitor/frame_0035.jpg', 'dslr/images/monitor/frame_0015.jpg', ...
        'webcam/images/monitor/frame_0036.jpg', 'dslr/images/monitor/frame_0016.jpg', ...
        'webcam/images/monitor/frame_0037.jpg', 'dslr/images/monitor/frame_0017.jpg', ...
        'webcam/images/monitor/frame_0038.jpg', 'dslr/images/monitor/frame_0018.jpg', ...
        'webcam/images/monitor/frame_0040.jpg', 'dslr/images/monitor/frame_0019.jpg', ...
        'webcam/images/monitor/frame_0041.jpg', 'dslr/images/monitor/frame_0020.jpg', ...
        'webcam/images/monitor/frame_0042.jpg', 'dslr/images/monitor/frame_0021.jpg', ...
        'webcam/images/monitor/frame_0043.jpg', 'dslr/images/monitor/frame_0022.jpg' ...
    },...
    {'webcam/images/mouse/frame_0005.jpg','dslr/images/mouse/frame_0001.jpg',...
    'webcam/images/mouse/frame_0005.jpg','dslr/images/mouse/frame_0002.jpg',...
    'webcam/images/mouse/frame_0001.jpg','dslr/images/mouse/frame_0003.jpg',...
    'webcam/images/mouse/frame_0009.jpg','dslr/images/mouse/frame_0006.jpg',...
    'webcam/images/mouse/frame_0017.jpg','dslr/images/mouse/frame_0007.jpg',...
    'webcam/images/mouse/frame_0014.jpg','dslr/images/mouse/frame_0008.jpg',...
    'webcam/images/mouse/frame_0021.jpg','dslr/images/mouse/frame_0009.jpg',...
    'webcam/images/mouse/frame_0022.jpg','dslr/images/mouse/frame_0010.jpg',...
    'webcam/images/mouse/frame_0027.jpg','dslr/images/mouse/frame_0011.jpg',...
    'webcam/images/mouse/frame_0028.jpg','dslr/images/mouse/frame_0012.jpg'
    },...
    {'webcam/images/mug/frame_0001.jpg','dslr/images/mug/frame_0001.jpg',...
    'webcam/images/mug/frame_0010.jpg','dslr/images/mug/frame_0002.jpg',...
    'webcam/images/mug/frame_0006.jpg','dslr/images/mug/frame_0003.jpg',...
    'webcam/images/mug/frame_0011.jpg','dslr/images/mug/frame_0004.jpg',...
    'webcam/images/mug/frame_0012.jpg','dslr/images/mug/frame_0005.jpg',...
    'webcam/images/mug/frame_0020.jpg','dslr/images/mug/frame_0006.jpg',...
    'webcam/images/mug/frame_0023.jpg','dslr/images/mug/frame_0007.jpg',...
    'webcam/images/mug/frame_0023.jpg','dslr/images/mug/frame_0008.jpg'
    },...
    {'webcam/images/paper_notebook/frame_0005.jpg','dslr/images/paper_notebook/frame_0001.jpg',...
    'webcam/images/paper_notebook/frame_0001.jpg','dslr/images/paper_notebook/frame_0002.jpg',...
    'webcam/images/paper_notebook/frame_0015.jpg','dslr/images/paper_notebook/frame_0003.jpg',...
    'webcam/images/paper_notebook/frame_0007.jpg','dslr/images/paper_notebook/frame_0004.jpg',...
    'webcam/images/paper_notebook/frame_0018.jpg','dslr/images/paper_notebook/frame_0005.jpg',...
    'webcam/images/paper_notebook/frame_0019.jpg','dslr/images/paper_notebook/frame_0006.jpg',...
    'webcam/images/paper_notebook/frame_0022.jpg','dslr/images/paper_notebook/frame_0007.jpg',...
    'webcam/images/paper_notebook/frame_0023.jpg','dslr/images/paper_notebook/frame_0008.jpg',...
    'webcam/images/paper_notebook/frame_0028.jpg','dslr/images/paper_notebook/frame_0009.jpg',...
    'webcam/images/paper_notebook/frame_0025.jpg','dslr/images/paper_notebook/frame_0010.jpg'
    },...
    {'webcam/images/pen/frame_0001.jpg','dslr/images/pen/frame_0001.jpg',...
    'webcam/images/pen/frame_0002.jpg','dslr/images/pen/frame_0002.jpg',...
    'webcam/images/pen/frame_0012.jpg','dslr/images/pen/frame_0003.jpg',...
    'webcam/images/pen/frame_0019.jpg','dslr/images/pen/frame_0006.jpg',...
    'webcam/images/pen/frame_0025.jpg','dslr/images/pen/frame_0007.jpg',...
    'webcam/images/pen/frame_0032.jpg','dslr/images/pen/frame_0009.jpg'
    },...
    {'webcam/images/phone/frame_0003.jpg','dslr/images/phone/frame_0001.jpg',...
    'webcam/images/phone/frame_0002.jpg','dslr/images/phone/frame_0002.jpg',...
    'webcam/images/phone/frame_0003.jpg','dslr/images/phone/frame_0003.jpg',...
    'webcam/images/phone/frame_0004.jpg','dslr/images/phone/frame_0004.jpg',...
    'webcam/images/phone/frame_0005.jpg','dslr/images/phone/frame_0005.jpg',...
    'webcam/images/phone/frame_0006.jpg','dslr/images/phone/frame_0006.jpg',...
    'webcam/images/phone/frame_0007.jpg','dslr/images/phone/frame_0007.jpg',...
    'webcam/images/phone/frame_0011.jpg','dslr/images/phone/frame_0008.jpg',...
    'webcam/images/phone/frame_0012.jpg','dslr/images/phone/frame_0009.jpg',...
    'webcam/images/phone/frame_0013.jpg','dslr/images/phone/frame_0010.jpg',...
    'webcam/images/phone/frame_0014.jpg','dslr/images/phone/frame_0011.jpg',...
    'webcam/images/phone/frame_0015.jpg','dslr/images/phone/frame_0012.jpg',...
    'webcam/images/phone/frame_0016.jpg','dslr/images/phone/frame_0013.jpg'
    },...
    {'webcam/images/printer/frame_0005.jpg','dslr/images/printer/frame_0001.jpg',...
    'webcam/images/printer/frame_0001.jpg','dslr/images/printer/frame_0002.jpg',...
    'webcam/images/printer/frame_0007.jpg','dslr/images/printer/frame_0003.jpg',...
    'webcam/images/printer/frame_0008.jpg','dslr/images/printer/frame_0004.jpg',...
    'webcam/images/printer/frame_0009.jpg','dslr/images/printer/frame_0005.jpg',...
    'webcam/images/printer/frame_0010.jpg','dslr/images/printer/frame_0006.jpg',...
    'webcam/images/printer/frame_0014.jpg','dslr/images/printer/frame_0007.jpg',...
    'webcam/images/printer/frame_0012.jpg','dslr/images/printer/frame_0008.jpg',...
    'webcam/images/printer/frame_0012.jpg','dslr/images/printer/frame_0009.jpg',...
    'webcam/images/printer/frame_0015.jpg','dslr/images/printer/frame_0010.jpg',...
    'webcam/images/printer/frame_0016.jpg','dslr/images/printer/frame_0011.jpg',...
    'webcam/images/printer/frame_0017.jpg','dslr/images/printer/frame_0012.jpg',...
    'webcam/images/printer/frame_0020.jpg','dslr/images/printer/frame_0013.jpg',...
    'webcam/images/printer/frame_0019.jpg','dslr/images/printer/frame_0014.jpg',...
    'webcam/images/printer/frame_0018.jpg','dslr/images/printer/frame_0015.jpg'
    },...
    {'webcam/images/projector/frame_0008.jpg','dslr/images/projector/frame_0001.jpg',...
    'webcam/images/projector/frame_0003.jpg','dslr/images/projector/frame_0002.jpg',...
    'webcam/images/projector/frame_0010.jpg','dslr/images/projector/frame_0003.jpg',...
    'webcam/images/projector/frame_0011.jpg','dslr/images/projector/frame_0004.jpg',...
    'webcam/images/projector/frame_0012.jpg','dslr/images/projector/frame_0005.jpg',...
    'webcam/images/projector/frame_0013.jpg','dslr/images/projector/frame_0006.jpg',...
    'webcam/images/projector/frame_0017.jpg','dslr/images/projector/frame_0007.jpg',...
    'webcam/images/projector/frame_0016.jpg','dslr/images/projector/frame_0008.jpg',...
    'webcam/images/projector/frame_0015.jpg','dslr/images/projector/frame_0009.jpg',...
    'webcam/images/projector/frame_0021.jpg','dslr/images/projector/frame_0010.jpg',...
    'webcam/images/projector/frame_0022.jpg','dslr/images/projector/frame_0011.jpg',...
    'webcam/images/projector/frame_0023.jpg','dslr/images/projector/frame_0012.jpg',...
    'webcam/images/projector/frame_0020.jpg','dslr/images/projector/frame_0013.jpg',...
    'webcam/images/projector/frame_0019.jpg','dslr/images/projector/frame_0014.jpg',...
    'webcam/images/projector/frame_0018.jpg','dslr/images/projector/frame_0015.jpg',...
    'webcam/images/projector/frame_0024.jpg','dslr/images/projector/frame_0016.jpg',...
    'webcam/images/projector/frame_0028.jpg','dslr/images/projector/frame_0017.jpg',...
    'webcam/images/projector/frame_0029.jpg','dslr/images/projector/frame_0018.jpg',...
    'webcam/images/projector/frame_0030.jpg','dslr/images/projector/frame_0019.jpg'
    },...
    {'webcam/images/punchers/frame_0005.jpg','dslr/images/punchers/frame_0001.jpg',...
    'webcam/images/punchers/frame_0015.jpg','dslr/images/punchers/frame_0003.jpg',...
    'webcam/images/punchers/frame_0016.jpg','dslr/images/punchers/frame_0004.jpg',...
    'webcam/images/punchers/frame_0017.jpg','dslr/images/punchers/frame_0005.jpg',...
    'webcam/images/punchers/frame_0014.jpg','dslr/images/punchers/frame_0006.jpg',...
    'webcam/images/punchers/frame_0013.jpg','dslr/images/punchers/frame_0007.jpg',...
    'webcam/images/punchers/frame_0012.jpg','dslr/images/punchers/frame_0008.jpg',...
    'webcam/images/punchers/frame_0021.jpg','dslr/images/punchers/frame_0009.jpg',...
    'webcam/images/punchers/frame_0022.jpg','dslr/images/punchers/frame_0010.jpg',...
    'webcam/images/punchers/frame_0023.jpg','dslr/images/punchers/frame_0011.jpg',...
    'webcam/images/punchers/frame_0018.jpg','dslr/images/punchers/frame_0012.jpg',...
    'webcam/images/punchers/frame_0019.jpg','dslr/images/punchers/frame_0013.jpg',...
    'webcam/images/punchers/frame_0020.jpg','dslr/images/punchers/frame_0014.jpg',...
    'webcam/images/punchers/frame_0027.jpg','dslr/images/punchers/frame_0016.jpg',...
    'webcam/images/punchers/frame_0024.jpg','dslr/images/punchers/frame_0017.jpg',...
    'webcam/images/punchers/frame_0025.jpg','dslr/images/punchers/frame_0018.jpg'
    },...
    {'webcam/images/ring_binder/frame_0007.jpg','dslr/images/ring_binder/frame_0001.jpg',...
    'webcam/images/ring_binder/frame_0006.jpg','dslr/images/ring_binder/frame_0002.jpg',...
    'webcam/images/ring_binder/frame_0013.jpg','dslr/images/ring_binder/frame_0003.jpg',...
    'webcam/images/ring_binder/frame_0014.jpg','dslr/images/ring_binder/frame_0004.jpg',...
    'webcam/images/ring_binder/frame_0008.jpg','dslr/images/ring_binder/frame_0005.jpg',...
    'webcam/images/ring_binder/frame_0021.jpg','dslr/images/ring_binder/frame_0006.jpg',...
    'webcam/images/ring_binder/frame_0029.jpg','dslr/images/ring_binder/frame_0007.jpg',...
    'webcam/images/ring_binder/frame_0031.jpg','dslr/images/ring_binder/frame_0008.jpg',...
    'webcam/images/ring_binder/frame_0033.jpg','dslr/images/ring_binder/frame_0009.jpg',...
    'webcam/images/ring_binder/frame_0035.jpg','dslr/images/ring_binder/frame_0010.jpg'
    },...
    {'webcam/images/ruler/frame_0003.jpg','dslr/images/ruler/frame_0001.jpg',...
    'webcam/images/ruler/frame_0004.jpg','dslr/images/ruler/frame_0002.jpg',...
    'webcam/images/ruler/frame_0001.jpg','dslr/images/ruler/frame_0003.jpg',...
    'webcam/images/ruler/frame_0008.jpg','dslr/images/ruler/frame_0004.jpg',...
    'webcam/images/ruler/frame_0009.jpg','dslr/images/ruler/frame_0005.jpg',...
    'webcam/images/ruler/frame_0010.jpg','dslr/images/ruler/frame_0006.jpg',...
    'webcam/images/ruler/frame_0011.jpg','dslr/images/ruler/frame_0007.jpg'
    },...
    {'webcam/images/scissors/frame_0006.jpg','dslr/images/scissors/frame_0001.jpg',...
    'webcam/images/scissors/frame_0005.jpg','dslr/images/scissors/frame_0002.jpg',...
    'webcam/images/scissors/frame_0011.jpg','dslr/images/scissors/frame_0003.jpg',...
    'webcam/images/scissors/frame_0011.jpg','dslr/images/scissors/frame_0004.jpg',...
    'webcam/images/scissors/frame_0016.jpg','dslr/images/scissors/frame_0005.jpg',...
    'webcam/images/scissors/frame_0016.jpg','dslr/images/scissors/frame_0006.jpg',...
    'webcam/images/scissors/frame_0023.jpg','dslr/images/scissors/frame_0015.jpg',...
    'webcam/images/scissors/frame_0025.jpg','dslr/images/scissors/frame_0016.jpg'
    },...
    {'webcam/images/speaker/frame_0002.jpg','dslr/images/speaker/frame_0001.jpg',...
    'webcam/images/speaker/frame_0003.jpg','dslr/images/speaker/frame_0002.jpg',...
    'webcam/images/speaker/frame_0008.jpg','dslr/images/speaker/frame_0003.jpg',...
    'webcam/images/speaker/frame_0007.jpg','dslr/images/speaker/frame_0004.jpg',...
    'webcam/images/speaker/frame_0012.jpg','dslr/images/speaker/frame_0006.jpg',...
    'webcam/images/speaker/frame_0012.jpg','dslr/images/speaker/frame_0007.jpg',...
    'webcam/images/speaker/frame_0013.jpg','dslr/images/speaker/frame_0008.jpg',...
    'webcam/images/speaker/frame_0015.jpg','dslr/images/speaker/frame_0009.jpg',...
    'webcam/images/speaker/frame_0016.jpg','dslr/images/speaker/frame_0010.jpg',...
    'webcam/images/speaker/frame_0016.jpg','dslr/images/speaker/frame_0011.jpg',...
    'webcam/images/speaker/frame_0017.jpg','dslr/images/speaker/frame_0012.jpg',...
    'webcam/images/speaker/frame_0018.jpg','dslr/images/speaker/frame_0013.jpg',...
    'webcam/images/speaker/frame_0019.jpg','dslr/images/speaker/frame_0015.jpg',...
    'webcam/images/speaker/frame_0019.jpg','dslr/images/speaker/frame_0016.jpg',...
    'webcam/images/speaker/frame_0020.jpg','dslr/images/speaker/frame_0017.jpg',...
    'webcam/images/speaker/frame_0022.jpg','dslr/images/speaker/frame_0018.jpg',...
    'webcam/images/speaker/frame_0023.jpg','dslr/images/speaker/frame_0019.jpg',...
    'webcam/images/speaker/frame_0024.jpg','dslr/images/speaker/frame_0020.jpg',...
    'webcam/images/speaker/frame_0025.jpg','dslr/images/speaker/frame_0021.jpg',...
    'webcam/images/speaker/frame_0026.jpg','dslr/images/speaker/frame_0022.jpg',...
    'webcam/images/speaker/frame_0027.jpg','dslr/images/speaker/frame_0023.jpg',...
    'webcam/images/speaker/frame_0030.jpg','dslr/images/speaker/frame_0024.jpg',...
    'webcam/images/speaker/frame_0029.jpg','dslr/images/speaker/frame_0025.jpg',...
    'webcam/images/speaker/frame_0028.jpg','dslr/images/speaker/frame_0026.jpg'
    },...
    {'webcam/images/stapler/frame_0003.jpg','dslr/images/stapler/frame_0001.jpg',...
    'webcam/images/stapler/frame_0004.jpg','dslr/images/stapler/frame_0002.jpg',...
    'webcam/images/stapler/frame_0009.jpg','dslr/images/stapler/frame_0003.jpg',...
    'webcam/images/stapler/frame_0011.jpg','dslr/images/stapler/frame_0004.jpg',...
    'webcam/images/stapler/frame_0006.jpg','dslr/images/stapler/frame_0006.jpg',...
    'webcam/images/stapler/frame_0007.jpg','dslr/images/stapler/frame_0007.jpg',...
    'webcam/images/stapler/frame_0008.jpg','dslr/images/stapler/frame_0008.jpg',...
    'webcam/images/stapler/frame_0015.jpg','dslr/images/stapler/frame_0009.jpg',...
    'webcam/images/stapler/frame_0012.jpg','dslr/images/stapler/frame_0010.jpg',...
    'webcam/images/stapler/frame_0013.jpg','dslr/images/stapler/frame_0011.jpg',...
    'webcam/images/stapler/frame_0014.jpg','dslr/images/stapler/frame_0012.jpg',...
    'webcam/images/stapler/frame_0016.jpg','dslr/images/stapler/frame_0013.jpg',...
    'webcam/images/stapler/frame_0017.jpg','dslr/images/stapler/frame_0014.jpg',...
    'webcam/images/stapler/frame_0018.jpg','dslr/images/stapler/frame_0015.jpg',...
    'webcam/images/stapler/frame_0019.jpg','dslr/images/stapler/frame_0016.jpg',...
    'webcam/images/stapler/frame_0024.jpg','dslr/images/stapler/frame_0020.jpg',...
    'webcam/images/stapler/frame_0023.jpg','dslr/images/stapler/frame_0021.jpg'
    },...
    {'webcam/images/tape_dispenser/frame_0005.jpg','dslr/images/tape_dispenser/frame_0001.jpg',...
    'webcam/images/tape_dispenser/frame_0010.jpg','dslr/images/tape_dispenser/frame_0004.jpg',...
    'webcam/images/tape_dispenser/frame_0006.jpg','dslr/images/tape_dispenser/frame_0006.jpg',...
    'webcam/images/tape_dispenser/frame_0007.jpg','dslr/images/tape_dispenser/frame_0009.jpg',...
    'webcam/images/tape_dispenser/frame_0011.jpg','dslr/images/tape_dispenser/frame_0010.jpg',...
    'webcam/images/tape_dispenser/frame_0012.jpg','dslr/images/tape_dispenser/frame_0011.jpg',...
    'webcam/images/tape_dispenser/frame_0013.jpg','dslr/images/tape_dispenser/frame_0012.jpg',...
    'webcam/images/tape_dispenser/frame_0014.jpg','dslr/images/tape_dispenser/frame_0013.jpg',...
    'webcam/images/tape_dispenser/frame_0015.jpg','dslr/images/tape_dispenser/frame_0014.jpg',...
    'webcam/images/tape_dispenser/frame_0018.jpg','dslr/images/tape_dispenser/frame_0015.jpg',...
    'webcam/images/tape_dispenser/frame_0017.jpg','dslr/images/tape_dispenser/frame_0016.jpg',...
    'webcam/images/tape_dispenser/frame_0016.jpg','dslr/images/tape_dispenser/frame_0017.jpg',...
    'webcam/images/tape_dispenser/frame_0019.jpg','dslr/images/tape_dispenser/frame_0018.jpg',...
    'webcam/images/tape_dispenser/frame_0023.jpg','dslr/images/tape_dispenser/frame_0019.jpg',...
    'webcam/images/tape_dispenser/frame_0020.jpg','dslr/images/tape_dispenser/frame_0020.jpg',...
    'webcam/images/tape_dispenser/frame_0022.jpg','dslr/images/tape_dispenser/frame_0021.jpg',...
    'webcam/images/tape_dispenser/frame_0021.jpg','dslr/images/tape_dispenser/frame_0022.jpg'
    },...
    {'webcam/images/trash_can/frame_0001.jpg','dslr/images/trash_can/frame_0001.jpg',...
    'webcam/images/trash_can/frame_0004.jpg','dslr/images/trash_can/frame_0002.jpg',...
    'webcam/images/trash_can/frame_0007.jpg','dslr/images/trash_can/frame_0003.jpg',...
    'webcam/images/trash_can/frame_0008.jpg','dslr/images/trash_can/frame_0004.jpg',...
    'webcam/images/trash_can/frame_0006.jpg','dslr/images/trash_can/frame_0005.jpg',...
    'webcam/images/trash_can/frame_0010.jpg','dslr/images/trash_can/frame_0006.jpg',...
    'webcam/images/trash_can/frame_0011.jpg','dslr/images/trash_can/frame_0007.jpg',...
    'webcam/images/trash_can/frame_0012.jpg','dslr/images/trash_can/frame_0008.jpg',...
    'webcam/images/trash_can/frame_0016.jpg','dslr/images/trash_can/frame_0010.jpg',...
    'webcam/images/trash_can/frame_0017.jpg','dslr/images/trash_can/frame_0011.jpg',...
    'webcam/images/trash_can/frame_0018.jpg','dslr/images/trash_can/frame_0012.jpg',...
    'webcam/images/trash_can/frame_0019.jpg','dslr/images/trash_can/frame_0013.jpg',...
    'webcam/images/trash_can/frame_0021.jpg','dslr/images/trash_can/frame_0014.jpg',...
    'webcam/images/trash_can/frame_0020.jpg','dslr/images/trash_can/frame_0015.jpg'
    }...
};
